* fplot_deriv.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Plot a function and its derivative";
title2 "Quadratic function";
data fplot2;
	* Minimum and maximum values of x;
	xmin = -5;
	xmax = 5;
	* Divisions between xmin and xmax (more = smoother graph);
	xdiv = 100;
	* Calculate step length;
	xlength = (xmax-xmin)/xdiv;
	* Find x, y = f(x), and dy/dx values for the plot;
	do i=0 to xdiv;
		x = xmin + i*xlength;
		* quadratic function;
		y = -x**2 + 2*x + 5; 
		* derivative of this function;
		dydx = -2*x + 2;
		* Output x, y, and dydx to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=fplot2;
run;
* Plot y = f(x) and dydx;
proc gplot data=fplot2;
	plot y*x=1 dydx*x=2 / href=0 vref=0 overlay whref=3 wvref=3 vaxis=axis1 haxis=axis1;
	symbol1 i=join v=none c=red width=3;
	symbol2 i=join v=none c=blue width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
